

$(function () {
	
});

// Step #3
const cardForm = mp.cardForm({
  amount: "1",
  autoMount: true,
  form: {
    id: "form-checkout",
    cardholderName: {
      id: "form-checkout__cardholderName",
      placeholder: "Titular do cartão",
    },
    cardholderEmail: {
      id: "form-checkout__cardholderEmail",
      placeholder: "E-mail",
    },
    cardNumber: {
      id: "form-checkout__cardNumber",
      placeholder: "Número do cartão",
    },
    cardExpirationDate: {
      id: "form-checkout__cardExpirationDate",
      placeholder: "Data de vencimento (MM/YYYY)",
    },
    securityCode: {
      id: "form-checkout__securityCode",
      placeholder: "Código de segurança",
    },
    installments: {
      id: "form-checkout__installments",
      placeholder: "Parcelas",
    },
    identificationType: {
      id: "form-checkout__identificationType",
      placeholder: "Tipo de documento",
    },
    identificationNumber: {
      id: "form-checkout__identificationNumber",
      placeholder: "Número do documento",
    },
    issuer: {
      id: "form-checkout__issuer",
      placeholder: "Banco emissor",
    },
  },
  callbacks: {
    onFormMounted: error => {
      if (error) return 
		console.warn("Erro de Manipulação do Formulário montado: ", error);
      console.log("Formulário Montado");
    },
	onCardTokenReceived: (erros, dados) => {
            if(typeof erros != 'undefined'){
                erros.forEach((ee) => {
                    alert(ee.message);
                });
            }
        },
    onSubmit: event => {
      event.preventDefault();
      const {
        paymentMethodId: payment_method_id,
        issuerId: issuer_id,
        cardholderEmail: email,
        amount,
        token,
        installments,
        identificationNumber,
        identificationType,
      } = cardForm.getCardFormData();

      fetch(base_url +  "mercadopago/cartao", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify({
		  _token: _token,
          token,
          issuer_id,
          payment_method_id,
          transaction_amount: Number(amount),
          installments: Number(installments),
          description: "Descrição do produto",
          codigo 	 : $("#cobranca_id").val(),
          cliente_id : $("#cliente_id").val(),
          payer: {
            email,
            identification: {
              type: identificationType,
              number: identificationNumber,
            },
          },
        }),
      }).then(response => response.json()).then((dados)=>{
		  console.log(dados);
			if(dados.status === "approved"){
				alert("Pagamento efetuado com sucesso.");
				//window.location.reload();
			}else{
				alert("erro:" + dados.status)
			}
		}).finally(()=>{
			//
		});
    },
    onFetching: (resource) => {
      console.log("Buscando Recurso: ", resource);

      // Animate progress bar
      const progressBar = document.querySelector(".progress-bar");
      progressBar.removeAttribute("value");

      return () => {
        progressBar.setAttribute("value", "0");
      };
    }
  },
});

function iniciarBusca(){
    cronometro = setInterval(function(){
     verificarNotificacao();
	},5000); 	
}

function pararBusca(){    
    clearInterval(cronometro);
}

function verificarNotificacao(){
	var pedido_id 	= $("#pedido_id").val();
	$.ajax({
	   url: base_url + "carrinho/verificaSePedidoTemVenda/" + pedido_id,
	   type: "GET",
	   dataType: "json",
	   data:{},
		 success: function(data){
			 console.log(data);
			 if(data == true){
				 pararBusca();
				 fecharModal();
				 giraGira();
				 window.location.href = base_url + "pagar/finalizado/" + pedido_id;
			 }
		 }
		
	});	
 }
 
function pagarComPix(){
	var nome 		= $("#payerFirstName").val();
	var sobrenome 	= $("#payerLastName").val();
	var cpf 		= $("#docNumber").val();
	var email 		= $("#payerEmail").val();
	var codigo 		= $("#cobranca_id").val();
	var cliente_id 	= $("#cliente_id").val();
	$.ajax({
		   url: base_url + "mercadopago/pix",
		   type: "POST",
		   dataType: "json",
		   data:{
				"email"		:email,
				"nome"		:nome,
				"sobrenome"	:sobrenome,
				"cpf"		:cpf,			
				"codigo"	:codigo,			
				"cliente_id":cliente_id,			
		   	},
			 success: function(data){
				$("#imageQRCode").attr('src', 'data:image/png;base64,' + data.qr_code_base64);
				$("#codigoPix").val(data.qr_code);
				abrirModal("#pix");
				//iniciarBusca();
			 }
			
		});
	
}