<?php

namespace App\Http\Controllers;

use App\Service\CobrancaService;
use Illuminate\Routing\Controller;
use Illuminate\Http\Request;
use MercadoPago\Payer;
use MercadoPago\Payment;

class CartaoController extends Controller
{
 
    public function ver($uuid){
        $dados["cobranca"]          = CobrancaService::detalhe($uuid);    
        $dados["pagamentoJs"]       = true;
        return view("Pagamento.Cartao", $dados);
                
    }
    
    public function pagar(Request $r)
    {
        try {
            $p = new Payment();
            $p->transaction_amount  = (float)$r->transaction_amount;
            $p->token               = $r->token;
            $p->description         = $r->description;
            $p->installments        = (int)$r->installments;
            $p->payment_method_id   = $r->payment_method_id;
            $p->issuer_id           = $r->issuer_id;
            
            $payer                  = new Payer();
            $payer->email           = $r->payer['email'];
            $payer->identification  = $r->payer['identification'];
            $payer->first_name      = $r->cardholderName;
            $p->payer               = $payer;
            $p->save();
            
            if($p->error){
                return response()->json($p->error, 400);
            }
            
            $response = [
                'status' => $p->status,
                'status_detail' => $p->status_detail,
                'id' => $p->id
            ];
            
            return response()->json($retorno);
        }catch (\Exception $e){
			$retorno->erro 	= true;
			$retorno->titulo= "Erro";
			$retorno->erro 	= $e->getMessage();				
            return response()->json($retorno, 400);
        }
    }
 }
